<?php
// app/Models/Laporan.php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Laporan extends Model
{
    protected $table = 'laporan';
    
    protected $fillable = [
        'user_id', 'desa_id', 'dusun_id', 'jenis_laporan',
        'deskripsi', 'foto', 'latitude', 'longitude', 'status'
    ];

    protected $casts = [
        'latitude' => 'decimal:7',
        'longitude' => 'decimal:7',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function desa()
    {
        return $this->belongsTo(Desa::class);
    }

    public function dusun()
    {
        return $this->belongsTo(Dusun::class);
    }
}
